
/*usb_device_info.c غ 2009.11.27*/
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <asm/io.h>
#include <asm/system.h>

#include <linux/types.h> 
#include <linux/fs.h> 
#include <linux/mm.h> 
#include <linux/errno.h> 
#include <asm/segment.h> 
#include <asm/uaccess.h>



#define USB_DEVICE_INFO_MAJOR  112

/*IO CMD*/
#define USB_DEVICE_INFO_GET_ID  20 /*usb device id*/
#define USB_DEVICE_INFO_GET_VID 21
#define USB_DEVICE_INFO_GET_PID 22


static unsigned long usb_device_vid;
static unsigned long usb_device_pid;

void set_usb_device_vid(unsigned long vid)
{
    usb_device_vid = vid;
}

void set_usb_device_pid(unsigned long pid)
{
    usb_device_pid = pid;
}


static unsigned long get_usb_device_vid(void)
{
    return usb_device_vid;
}


static unsigned long get_usb_device_pid(void)
{
    return usb_device_pid;
}


static int open_ops(struct inode *inode, struct file *filp)
{ 
    printk("usb_device_info opened\n");
    static int usbdev_opened;
    if (usbdev_opened)
    {
        printk("you can't open an already opened device.\n");
        usbdev_opened = 1;
        return -1;
    }
    return 0;

} 

static int read_ops(struct file *filp, char *buf, size_t size, loff_t *loffp)
{
    char *msg = "usb device info";
    copy_to_user(buf, msg, sizeof(msg));
    return sizeof(msg);
} 
 
static int write_ops(struct file *filp, const char *buf, size_t size, loff_t *loffp)
{ 
    return 0; 
} 
static int ioctl_ops(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg)
{
    int ret = cmd;
    unsigned long default_value = 0;
    unsigned long vid, pid, id;
    vid = get_usb_device_vid();
    pid = get_usb_device_pid();
    id = (vid << 16)+pid;
    switch (cmd)
    {
    case USB_DEVICE_INFO_GET_ID:
        copy_to_user((void *)arg, &id, sizeof(id));
        break;
    case USB_DEVICE_INFO_GET_VID:        
        copy_to_user((void *)arg, &vid, sizeof(vid));
        break;
    
    case USB_DEVICE_INFO_GET_PID:
        copy_to_user((void *)arg, &pid, sizeof(pid));
        break;

    default:
        printk("Error cmd %d\n", cmd);
        copy_to_user((void *)arg, &default_value, sizeof(default_value));
        ret = -1;
        break;
    }

    return ret;
}


static int release_ops(struct inode *inode, struct file *filp)
{ 
    return 0;
} 
 
struct file_operations usb_device_info_fops = { 
    open: open_ops,
    read: read_ops,
    write: write_ops,
    ioctl: ioctl_ops,
    release: release_ops,
};  

static int __init usb_device_init_module(void) 
{ 
    int result; 
    result = register_chrdev(USB_DEVICE_INFO_MAJOR, "usbdevinf", &usb_device_info_fops); 
    if (result < 0) 
    { 
        printk(KERN_INFO "register usbdevinf failed\n"); 
        return result; 
    } 
    return 0; 
} 

static void __exit usb_device_cleanup_module(void) 
{ 
    unregister_chrdev(USB_DEVICE_INFO_MAJOR, "usbdevinf"); 
} 

module_init(usb_device_init_module)
module_exit(usb_device_cleanup_module)


