
/*
watchdog driver
   1a, 26Mar2005, lie created.
   9am, 06Sep2007, qinhongjun modified.
*/

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <linux/sched.h>
#include <linux/wait.h>
#include <linux/init.h>
#include <asm/uaccess.h>
#include "wdtu_watchdog.h"

MODULE_LICENSE("GPL");

#define DEVICE_NAME "wddev"
#define WD_MAJOR  253

#define DEBUG 0

#if DEBUG
#define TRACE printk
#else
#define TRACE 
#endif

static ssize_t wd_read(struct file *f, char *buf, size_t buf_size, loff_t *off);
static ssize_t wd_write(struct file *f, const char* buf, size_t buf_size, loff_t *off);
static int wd_open(struct inode *node, struct file *f);
static int wd_release(struct inode *node, struct file *f);
static int wd_ioctl(struct inode *node, struct file *f, unsigned int command, unsigned long value);

// global variables
static struct file_operations fops={
  read: wd_read,
  write: wd_write,
  open : wd_open,
  release:  wd_release,
  ioctl: wd_ioctl
};


#define GPIO_CFG        (*((volatile unsigned long *)(Base_Addr+0x83000)))
#define GPIO_DIR        (*((volatile unsigned long *)(Base_Addr+0x83004)))
#define GPIO_DATAOUT    (*((volatile unsigned long *)(Base_Addr+0x83008)))


#define RESET_SYSTEM				\
	do {				\
        GPIO_CFG &= (~(3 ));			\
		GPIO_DIR |= (1 << 2);			\
        GPIO_DATAOUT &= ~(1 << 2); \
        while(1);   \
	} while(0)


#define EXTERAL_WD_GPIO_REVERSE     do {GPIO_DATAOUT ^= (1 << 3);}while(0)
    
#define INIT_DOG    \
    do {     \ 
        GPIO_CFG &= ~(3);            \
        GPIO_DIR |= (1 << 3);         \ 
        GPIO_DATAOUT ^= (1 << 3);  \
		GPIO_DIR |= (1 << 2);			\
		GPIO_DATAOUT |= (1<<2);			\		
    }while(0)
    
#define ENABLE_DOG      \
    do {    \
        GPIO_DATAOUT ^= (1 << 3);  \
		GPIO_DATAOUT &= ~(1<<2);			\
    }while(0)
#define DISABLE_DOG    \
    do {    \
        GPIO_DATAOUT |= (1<<2);			\
    }while(0)

static int ref_cnt;
    
static int __init wd_init(void)
{
	int ret;
	ret = register_chrdev(WD_MAJOR, DEVICE_NAME, &fops);

	if (ret < 0) 
    {
		printk("watch dog device (%s) failed to register(%d).\r\n", DEVICE_NAME, ret);
	}
    ref_cnt = 0;
	return ret;
}

static void __exit wd_cleanup(void)
{
	int ret = unregister_chrdev(WD_MAJOR, DEVICE_NAME);
	printk("watch dog device (%s) relased: %d\r\n", DEVICE_NAME, ret);
}


static ssize_t wd_read(struct file *f, char *buf, size_t buf_size, loff_t* off)
{
	return 0;
}

static ssize_t wd_write(struct file *f, const char* buf, size_t buf_size, loff_t* off)
{
	return 0;
}

static int wd_open(struct inode *node, struct file *f)
{
	ref_cnt++;
	printk("%s opened(count = %d)\n", DEVICE_NAME, ref_cnt);
	return 0;
}

static int wd_release(struct inode *node, struct file *f)
{
	ref_cnt--;
	printk("%s released(count = %d)\n", DEVICE_NAME, ref_cnt);
	return 0;
}

static int wd_ioctl(struct inode *node, struct file *f, unsigned int cmd, unsigned long value)
{
    switch (cmd) 
     {
        case IOC_WD_CLR_DOG: //clear dog	
            printk("wtd CLR\r\n");
            EXTERAL_WD_GPIO_REVERSE;
			break;
		case IOC_WD_RESET_SYS: //reset sys
		    printk("wtd reset_sys\r\n");
			RESET_SYSTEM;
			break;		
		case IOC_WD_ENABLE_DOG: //enable dog
            printk("wtd enable\r\n");
            ENABLE_DOG;
			break;		
        case IOC_WD_DISABLE_DOG: 
            printk("wtd disable\r\n");
            DISABLE_DOG;
            break;
        case IOC_WD_INIT:
            printk("wtd init\r\n");
            INIT_DOG;
            break;
		default:
			printk("wddev: unknown ioctl command.\n");
			break;
	}
	
	return 0;
}

module_init(wd_init);
module_exit(wd_cleanup);


