
/*******************************************************************************
* ks8993m_main.c - MG6008A switch driver module
* 
* Copyright 2005-2005 Guangzhou Gaoke Communication Technology Co.,Ltd.
* 
* DESCRIPTION: This module implements the registration and unregistration of
*   KS8993M switch driver for MG6008A board
*
* modification history
* --------------------
* 01a, 09aug05, dengxuejie written
*
*******************************************************************************/

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/major.h>  /* SWITCH_MAJOR = 248 */
#include "8201.h"
#include <asm/uaccess.h>
#include "w740mac.h"
/* return status values */
#define OK      0
#define ERROR   (-1)



#define ADDRESS_MASK  0x7F
#define REGADDR_MASK  0x1F
#define PHYADDR_MASK  0x60

#define PHYADDR_PEND  0x04




extern unsigned long MiiStationRead(int num, unsigned long PhyInAddr, unsigned long PhyAddr,int * succ);
extern int MiiStationWrite(int num,unsigned long PhyInAddr,unsigned long PhyAddr,unsigned long PhyWrData,int * succ );
static int motFecPhyRead(unsigned char phyAddr, unsigned char regAddr, unsigned short *retVal)
{
    int success;
    unsigned int PhyInAddr = regAddr;
    int mac_num = ((phyAddr & 0xC0)>>6);
    unsigned int PhyAddr = (phyAddr & 0x3F);
    *retVal = MiiStationRead(mac_num, PhyInAddr, PhyAddr<<8, &success);
    return ((success == 1) ? OK:ERROR);
}
static int motFecPhyWrite(unsigned char phyAddr, unsigned char regAddr, unsigned short data)
{   
    int success;
    unsigned int PhyInAddr = regAddr;
    int mac_num = ((phyAddr & 0xC0)>>6);
    unsigned int PhyAddr = (phyAddr & 0x3F);
    MiiStationWrite(mac_num, PhyInAddr, PhyAddr<<8, data, &success);
    return ((success == 1) ? OK:ERROR);
}

/* forward declarations */

static int KS8993MRegSet(int regNo, unsigned long value)
{
    unsigned char phyaddr = 0;
    unsigned char regaddr = 0;
    unsigned short regval = 0;

    //phyaddr = 22;//((((regNo&PHYADDR_MASK)>>5)&0x03)<<3)|PHYADDR_PEND;
    phyaddr = (regNo & 0xff00) >> 8;
    regaddr = (regNo&REGADDR_MASK);
    regval |= value;
    return motFecPhyWrite(phyaddr, regaddr, regval);
}

/*******************************************************************
 * KS8993MRegGet - get ks8993m chip registers' configurations.
 * DISCRIPTION:
 * INPUTS: regNo - register number(0 - 127)
 *         *value - points to value got from register
 * OUTPUT: *value - points to value got from register
 * RETURN: OK - success or ERROR - fail
 *
 * modification history
 * -----------------------------------
 * 01a, 18Nov04, tanghuaxin written.
 * -----------------------------------------------------------
 *****************************************************************/
static int KS8993MRegGet(int regNo, unsigned long *value)
{
    unsigned char phyaddr = 0;
    unsigned char regaddr = 0;
    unsigned long regval = 0;
    int retval = ERROR;

    phyaddr = (regNo & 0xFF00) >> 8;
    regaddr = (regNo & 0xFF);
 
    if (OK == motFecPhyRead(phyaddr, regaddr, &regval))
    {
        *value = regval;
        retval = OK;
    }
    *value = regval;
    retval = OK; 
    return retval;
}




/*******************************************************************
 * nResetPort - reset ks8993m port.
 * DISCRIPTION:
 * INPUTS: port - port number(0 - 2)
 * OUTPUT: N/A
 * RETURN: OK - success or ERROR - fail
 *
 * modification history
 * -----------------------------------
 * 01a, 18Nov04, tanghuaxin written.
 * -----------------------------------------------------------
 *****************************************************************/
static int nResetPort(int port)
{

    return OK;
}

/*******************************************************************
 * nResetChip - reset ks8993m chip.
 * DISCRIPTION:
 * INPUTS: N/A
 * OUTPUT: N/A
 * RETURN: OK - success or ERROR - fail
 *
 * modification history
 * -----------------------------------
 * 01a, 18Nov04, tanghuaxin written.
 * -----------------------------------------------------------
 *****************************************************************/
static int nResetChip(void)
{
   

    return OK;
}

/*******************************************************************
 * nInitKS8993M - initialize ks8993m chip.
 * DISCRIPTION:
 * INPUTS: N/A
 * OUTPUT: N/A
 * RETURN: OK - success or ERROR - fail
 *
 * modification history
 * -----------------------------------
 * 01a, 18Nov04, tanghuaxin written.
 * -----------------------------------------------------------
 *****************************************************************/
int nInitKS8993M(void)
{
    /* unsigned char regVal = 0; */
    

    return nResetChip();
}





static int ks8993m_ioctl(struct inode *inode, struct file *filp,
   unsigned int cmd, unsigned long arg)
{
    int ret = -1;
    unsigned long retVal = 0;
    unsigned long param = 0;

    switch (cmd)
    {


    /* register */
    case RTL8201_GET_REG:
        copy_from_user(&param, (void *)arg, sizeof(int)); 
        //phyAddr = (param.num & 0xFF00) >> 8;
        ret = KS8993MRegGet((int)param, &retVal);
        if (OK == ret)
        {
            param = (int)retVal;
            copy_to_user((void *)arg, &param, sizeof(int));
        }
        break;
    
    case RTL8201_SET_REG:
        copy_from_user(&param, (void *)arg, sizeof(int));
        retVal = ((param & 0xffff0000) >> 16);
        ret = KS8993MRegSet((int)(param & 0xffff), retVal);
        break;

    default:
        printk("Error cmd %d\n", cmd);
        break;
    }

    return ret;
}

static int ks8993m_open(struct inode *inode, struct file *filp)
{
    static int ks8993m_opened = 0;
    if (1 == ks8993m_opened)
    {
        // printk("you can't open an already opened switch device.\n");
        return 0;
    }
    ks8993m_opened = 1;
    return 0;
}

static int ks8993m_release(struct inode *inode, struct file *filp)
{
    return 0;
}

/* the driver callbacks */
struct file_operations switch_rtl8201_fops =
{
   ioctl: ks8993m_ioctl,
   open: ks8993m_open,
   release: ks8993m_release
};



static int __init switch_init_module(void)
{
    int res;
    /* register rtc device */
    res = register_chrdev(SWITCH_MAJOR, "switch", &switch_rtl8201_fops);           
    if (res < 0) 
    {
        printk(KERN_ERR "Could not register switch device!\n");
        return ERROR;
    }
        
    return OK; /* succeed */
}

/*
 * The cleanup function is used to handle initialization failures as well.
 * Thefore, it must be careful to work correctly even if some of the items
 * have not been initialized
 */
static void __exit switch_cleanup_module(void)
{
    unregister_chrdev(SWITCH_MAJOR, "switch");
}

module_init(switch_init_module)
module_exit(switch_cleanup_module)


